﻿#using System.IO;
#using System.Threading.Tasks; 

#using Tessa.Cards;
#using Tessa.Cards.Numbers;

const string bAgreedAlias = "Agreed";
const string bRebuildAlias = "Rebuild";

const string justificationSectionAlias = "ExJustification";
const string verificationResultAlias = "VerificationResult";

const string mCardFileCategoryName = "Финансовое обоснование";

var mCard = await this.Context.GetMainCardAsync(cancellationToken: this.Context.CancellationToken);
var dCard = await dialog.GetCardObjectAsync();
var dCardFiles = dCard.TryGetFiles();

// В карточке диалога нет файлов?
if(dCardFiles?.Any() != true)
{
	return;
}

if(string.Equals(dialog.ButtonName, bAgreedAlias, StringComparison.Ordinal)
	|| string.Equals(dialog.ButtonName, bRebuildAlias, StringComparison.Ordinal))
{
	Dictionary<Guid, Guid> fileIDContentSources;
	
	if(this.Process.FileIDContentSources is Dictionary<string, object> fileIDContentSourcesObjDict)
	{
		fileIDContentSources = fileIDContentSourcesObjDict.ToDictionary(i => Guid.ParseExact(i.Key, "N"), j => Guid.ParseExact((string)j.Value, "N"));
	}
	else
	{
		fileIDContentSources = null;
	}

	Guid? GetFileIDContentSource(Guid fileRowID)
	{
		if(fileIDContentSources != null
			&& fileIDContentSources.TryGetValue(fileRowID, out var fileIDContentSource))
		{
			return fileIDContentSource;
		}
		return default;
	}
	mCard.Sections[justificationSectionAlias].Fields[verificationResultAlias] = dCard.Sections[justificationSectionAlias].Fields[verificationResultAlias];

	var mCardFileContainer = (await this.Context.GetFileContainerAsync(cancellationToken: this.Context.CancellationToken)).FileContainer;
	var mFiles = mCardFileContainer.Files;
	
	// Удаление файлов из основной карточки, удалённых из карточки диалога.
	var deletedFileIDCollection = mFiles
		.Where(mFile => string.Equals(mFile.Category?.Caption, mCardFileCategoryName, StringComparison.Ordinal))
		.Select(mFile => mFile.ID)
		.Except(dCardFiles
			.Select(dCardFile => GetFileIDContentSource(dCardFile.RowID))
			.Where(mFileID => mFileID.HasValue)
			.Cast<Guid>()).ToArray();

	for(var i = 0; i < deletedFileIDCollection.Length; i++)
	{
		await mFiles.RemoveWithNotificationAsync(mFiles.TryGet(deletedFileIDCollection[i]), cancellationToken: this.Context.CancellationToken);
	}

	// Перенос файлов из карточки диалога в основную карточку.
	var dCardFileContainer = (await dialog.GetFileContainerAsync()).FileContainer;

	ValidationResult result;
	foreach(var dFile in dCardFileContainer.Files)
	{
		var fileIDContentSource = GetFileIDContentSource(dFile.ID);

		// Файл был перенесён из основной карточки?
		if(fileIDContentSource.HasValue)
		{
			var mFile = mFiles.TryGet(fileIDContentSource.Value);

			if(dFile.TryGetActualVersion().Number > 1)
			{
				if(!dFile.Content.HasData)
				{
					result = await dFile.EnsureContentDownloadedAsync(cancellationToken: this.Context.CancellationToken);
					this.ValidationResult.Add(result);

					if(result.HasErrors)
					{
						return;
					}
				}

				result = await mFile.ReplaceAsync(await dFile.Content.GetAsync(this.Context.CancellationToken), this.Context.CancellationToken);
				this.ValidationResult.Add(result);
				
				if(result.HasErrors)
				{
					return;
				}
			}

			result = await mFile.RenameAsync(dFile.Name, this.Context.CancellationToken);
			this.ValidationResult.Add(result);
			
			if(result.HasErrors)
			{
				return;
			}
		}
		else
		{
			if(!dFile.Content.HasData)
			{
				result = await dFile.EnsureContentDownloadedAsync(cancellationToken: this.Context.CancellationToken);
				this.ValidationResult.Add(result);

				if(result.HasErrors)
				{
					return;
				}
			}

			result = (await mCardFileContainer
				.BuildFile(dFile.Name)
				.SetContent(dFile.Content)
				.SetVersionToken(
					(ft, ct) =>
					{
						var lastVersion = dFile.Versions.Last();
						
						ft.Created = lastVersion.Created;
						ft.CreatedByID = lastVersion.CreatedByID;
						ft.CreatedByName = lastVersion.CreatedByName;
						
						ft.Hash = lastVersion.Hash;
						
						return new ValueTask();
					})
				.SetCategory(mCardFileCategoryName)
				.AddWithNotificationAsync(cancellationToken: this.Context.CancellationToken)).Result;
			this.ValidationResult.Add(result);

			if(result.HasErrors)
			{
				return;
			}
		}
	}
}